/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef _WIN32
   #define WIN32_EXTRA_LEAN
   #include <windows.h>
#include <io.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#ifdef _WIN32
#include <tchar.h>
#endif

#include "precomp.h"
#include "../../cpc/host.h"


HOST_FILE_HANDLE	Host_OpenFile(char *Filename, int Access)
{
	HOST_FILE_HANDLE fh;
	fh = 0;

	if (Access == HOST_FILE_ACCESS_READ)
	{
		fopen_s((FILE**)fh,Filename,"rb");
		//fh = (HOST_FILE_HANDLE)fopen(Filename,"rb");
	}
	else
	{
		fopen_s((FILE**)fh,Filename,"wb");
		//fh = (HOST_FILE_HANDLE)fopen(Filename,"wb");
	}

	return fh;
}

void	Host_CloseFile(HOST_FILE_HANDLE Handle)
{
	if (Handle!=0)
	{
		fclose((FILE *)Handle);
	}
}

int	Host_GetFileSize(HOST_FILE_HANDLE Handle)
{
	if (Handle!=0)
	{
		int fno = _fileno((FILE *)Handle);

		return _filelength(fno);
	}

	return 0;
}



void	Host_ReadData(HOST_FILE_HANDLE Handle, unsigned char *pData, unsigned long Size)
{
	if (Handle!=0)
	{
		fread(pData, Size, 1, (FILE *)Handle);
	}
}

void	Host_WriteData(HOST_FILE_HANDLE Handle, unsigned char *pData, unsigned long Size)
{
	if (Handle!=0)
	{
		fwrite(pData, Size, 1, (FILE *)Handle);
	}
}

